//Playback utilities

#ifndef _PLAY_H
#define _PLAY_H
#include <xc.h>
#include <sys/attribs.h>
#include "sdcard/ff.h"
#include "WAV.h"
#include <string.h>

//HW sample rate set by processor speed 24MHz / 512 ((BRG*2+2) x 32bits/sample)
#define HW_SAMPLERATE 46875

//limits for speed bending:
#define ADJ_SAMPLERATE_LOWER 1000
#define ADJ_SAMPLERATE_UPPER 65000

//should be the same as in samples.h
#define INTERNAL_SAMPLE_F 6000

//check these are the same as in main
#define BUF_COUNT 4
#define DAC_BUF_SIZE 512
#define RAW_BUF_SIZE (DAC_BUF_SIZE*6)
#define INTERNAL_SIZE 512

//#define HEADER_SIZE 44
#define HEADER_SIZE 256

//TLENGTH long enough to hold a LFN
#define PLENGTH 64
#define TLENGTH 256

//for pulse/PWM counter, number of DAC cycles, arbitrary as long as non-zero: 4687 gives ~10Hz update
#define PULSE_PERIOD 4687
volatile uint32_t inputFreq=0;           //for main to read

typedef enum {
	MODEMIXED=1,
    MODEDSELECT,
    MODEPLAYER,
} MAINMODE;

typedef enum {
    SPEAKBACKNONE=0,
    SPEAKBACKSUMMARY,
    SPEAKBACKALL
} SPEAKBACK;

typedef enum {
    SW4TRIGGER=0,
    SW4ANALOG,
    SW4FREQUENCY
} SW4MODE;

typedef enum {
    MIXED_NONE=0,
    MIXED_LOOP=1,
    MIXED_SINGLE,
    MIXED_CROPLOOP,
    MIXED_CROPSINGLE,
    MIXED_ASR,
    MIXED_ALTLOOP,
    MIXED_ROUNDROBIN,
    MIXED_RANDOM
} MIXEDINPUT;

extern char mainMode;
extern char speakBack;                              //how much config is spoken back
extern char activeLogicLevel;                       //0 is active low (normal), 1 is high
extern char reg1Needed;                             //for speakback only
extern uint32_t powerTimeOut;                       //standby timeout

#define SW4_FULL_SCALE 256  
extern uint32_t SW4scalevalue;                        //adjusted from SW4rawvalue to 0-100% (constrained to range), see main.c
extern char SW4mode;                                  //default to normal trigger, see SW4MODE in play.h
extern uint32_t SW4rawlow;                            //what raw value scales to 0%
extern uint32_t SW4rawhigh;                           //what raw value scales to 100%

//see these also in main
#define INPUT_COUNT 7
#define HANDLES_PER_INPUT 10
extern FIL mixedhandles[INPUT_COUNT][HANDLES_PER_INPUT];     //7 inputs, up to 3 handles each for mixed mode
//extern int32_t soundVolume[INPUT_COUNT];                     // 0-256
extern char soundMode[INPUT_COUNT];                          //see MIXEDINPUT enum in play.h

//actual adjustment is speedScale/SPEED_SCALE_DIVIDER       
#define SPEED_SCALE_DIVIDER 256
uint32_t speedScaleMin[INPUT_COUNT];                                       //scaling that applies when SW4scalevalue=0, loaded from card
uint32_t speedScaleMax[INPUT_COUNT];                                       //scaling that applies when SW4scalevalue=SW4_FULL_SCALE, loaded from card
uint32_t speedScaleMinChannel[BUF_COUNT];                                  //scaling that applies when SW4scalevalue=0, set at playback
uint32_t speedScaleMaxChannel[BUF_COUNT];                                  //scaling that applies when SW4scalevalue=SW4_FULL_SCALE, set at playback

extern FRESULT f[BUF_COUNT];
extern FIL filetoopen[BUF_COUNT];

extern int16_t dacbuf[BUF_COUNT][3][DAC_BUF_SIZE];             //data ready for DAC
volatile extern unsigned int dacbufinuse[BUF_COUNT];                    //buffer of 3 in use
volatile extern unsigned int dacbufptr[BUF_COUNT];                      //pointer in that buffer
volatile extern unsigned int dacbufend[BUF_COUNT][3];                   //number of samples in buffer
extern signed int dacbufVolume[BUF_COUNT];                   //volume for current buffer, set from input

extern signed int switchVolumeMin[INPUT_COUNT];                 //for adjustable volumes
extern signed int switchVolumeMax[INPUT_COUNT];
extern signed int dacbufVolumeMin[BUF_COUNT];
extern signed int dacbufVolumeMax[BUF_COUNT];

//for raw data before processing
char rawBuf[RAW_BUF_SIZE];                                      //6 x DAC buffer size is enough for 64kHz 16-bit sterero
int16_t rawDACbuf[RAW_BUF_SIZE];                                //converted to 16bit but not samplerate adjusted
static int16_t rawBufLast[BUF_COUNT];                          //last sample from last load to be used as first sample for next
extern int32_t masterVolume;                                   //0-256
char headerBuf[HEADER_SIZE];                                   //just read one file at a time
unsigned int headerBufRead=0;                                  //bytes actually read
WAVHeader header[BUF_COUNT];
extern char filenames[BUF_COUNT][13];                           //filenames used for opening
extern char clipping;                                           //set if clipping detected
extern unsigned char wav_num_channels[], wav_bytes_per_sample[];
extern unsigned long wav_sample_rate[];
extern char playing[BUF_COUNT];                                         //set to zero on finish
extern char playingInt[BUF_COUNT];                                      //set to zero on finish
extern char fileToRead[BUF_COUNT];                      // data available to read
extern const int32_t sine[512];                                     //sinewave

//found in samples.h
extern const unsigned char* sampleData[];
extern const uint32_t sampleSize[];

unsigned int getDACsamples(char c, char buftofill);              //returns number samples got
void openFile(char c);                                           //starts read, set wav parameters
//void openFile(FIL handle, char c);                               //read arbitrary file
void initFile(char c);                                           //inits file pointer for openFile - separate because its slow
unsigned int internalSamples(char c,  char buftofill, unsigned int f);      //load from internal sample
char loadConfig(char *cfilename);                                 //load from config file, returns if file read OK 
void parseToken(char *token, unsigned int tNo);                   //
int strMatch(char *a, char *b);                                   //check if strings match
int findBuffer();                                                 //find free buffer or -1
uint32_t internalWave(char c,  char buftofill, char sNumber, uint32_t s);   //load samples from flash
void playInternalWave(char c, char sNumber);                      //asynchronously play sound from flash
void sayNumber(uint32_t n);                                       //use internal samples to say n
void speakConfig(char n);                                         //use internal samples to speak config
void playSampleSelect();                                          //use SW1-SW6 as binary select and SW7 as trigger to internal samples
extern void delay(uint32_t t);                                    //in util.h
unsigned char getSW(unsigned char n);                             //in io.h

#endif //_PLAY_H
